% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample_permuted_networks.R
\name{subsampled_permuted_network_metrics}
\alias{subsampled_permuted_network_metrics}
\title{To generate subsamples of the permuted networks and obtain network metrics of those subsamples}
\usage{
subsampled_permuted_network_metrics(
  networks_list,
  subsampling_proportion = c(0.1, 0.3, 0.5, 0.7, 0.9),
  network_metrics_functions_list = c(edge_density = function(x) igraph::edge_density(x),
    diameter = function(x) igraph::diameter(x, weights = NA), transitivity = function(x)
    igraph::transitivity(x))
)
}
\arguments{
\item{networks_list}{A list of igraph objects obtained by permuting the observed network}

\item{subsampling_proportion}{A vector depicting the levels (in proportion) at which subsamples to be taken}

\item{network_metrics_functions_list}{A list consisting of function definitions of the network metrics that the user wants to evaluate. Each element in the list should have an assigned name.
Default = c("edge_density" = function(x) igraph::edge_density(x), "diameter" = function(x) igraph::diameter(x, weights = NA), "transitivity" = function(x) igraph::transitivity(x))}
}
\value{
A list of network metrics of class "Subsampled_Permuted_Network_Metrics". Each element of list is a matrix whose columns 
        correspond to subsampling_proportion and rows correspond to the number of networks in networks_list. 
        The entries of the matrix provide values of the corresponding metric.
}
\description{
To generate subsamples of the permuted networks and obtain network metrics of those subsamples
}
\examples{
\donttest{
data(elk_2010_permutations)
elk_subsamples_permuted_networks <- subsampled_permuted_network_metrics(elk_2010_permutations)
plot(elk_subsamples_permuted_networks, elk_network_2010)
}
}
