% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimic_gif.R
\name{mimic_gif}
\alias{mimic_gif}
\title{Animation of several mimicking datasets}
\usage{
mimic_gif(
  x,
  x2,
  idempotent = TRUE,
  theme_name = "classic",
  ease = "cubic-in-out",
  transition_length = 3,
  state_length = 1,
  wrap = TRUE
)
}
\arguments{
\item{x}{A list of input datasets.  Each one must be suitable argument
\code{x} for for \code{\link{mimic}}.}

\item{x2}{A suitable argument \code{x2} for \code{\link{mimic}}.}

\item{idempotent}{A logical vector that provides the argument of the same
names to \code{\link{mimic}} for each dataset.  If necessary, \code{\link{rep_len}} is used to
replicate this argument so that it has length \code{length(x)}.}

\item{theme_name}{A character scalar used to set the
\code{\link[ggplot2:ggtheme]{ggtheme}}.
One of \code{"grey"}, \code{"gray"}, \code{"bw"}, \code{"linedraw"}, \code{"light"}, \code{"dark"},
\code{"minimal"}, \code{"classic"}, \code{"void"} or \code{"test"}.}

\item{ease}{A character scalar passed to \code{\link[gganimate:ease_aes]{ease_aes}}
to control how the points move in transitioning from one dataset to
the next.}

\item{transition_length, state_length, wrap}{Arguments passed to
\code{\link[gganimate:transition_states]{transition_states}}.}
}
\value{
An object of class \code{c("gganim", "gg", "ggplot")} with an additional
attribute \code{new_data} that is a data frame with 3 variables, \code{x}, \code{y} and
\code{dataset} containing the datasets output from \code{mimc}.

The returned object may be displayed using by typing its name,
e.g., \code{anim} or saved as a GIF file using
\code{\link[gganimate:anim_save]{anim_save}}, e.g.,
\code{gganimate::anim_save("anscombe.gif", anim)}.
}
\description{
Create an animation to show datasets that mimic a target dataset \code{x2}.
}
\details{
For this function to work the packages
\code{\link[ggplot2:ggplot2-package]{ggplot2}} and
\code{\link[gganimate:gganimate-package]{gganimate}} must be installed.
}
\examples{
# Create 8 datasets that mimic Anscombe's first dataset
x <- list(input1, input2, input3, input4, input5, input6, input7, input8)
anim <- mimic_gif(x, anscombe1)
}
\seealso{
\code{\link{mimic}} to modify a dataset to share sample summary statistics
with another dataset.

\code{\link{input_datasets}}: \code{input1} to \code{input8} for some input datasets
of the same size as those in Anscombe's quartet.
}
