% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNetLoad.R
\name{addNetLoad}
\alias{addNetLoad}
\title{Net load of areas}
\usage{
addNetLoad(x, ignoreMustRun = FALSE)
}
\arguments{
\item{x}{An \code{antaresData} object created with readAntares. Unless
\code{ignoreMustRun} is true, it must
have a column  \code{mustRunTotal}.}

\item{ignoreMustRun}{If \code{TRUE}, the production in must run mode is not substracted to the
net load.}
}
\value{
\code{addNetLoad} modifies its input by adding to it a column "netLoad". For
convenience, it invisibly returns the modified input.
             formula = LOAD - `ROW BAL.` - PSP - `MISC. NDG` - `H. ROR` - WIND - SOLAR - mustRunTotal
}
\description{
This function computes the net load of areas or districts and add it to an
\code{antaresData} object. Net load is the load of an area minus productions
that are not controlled: wind, solar, hydraulic run of river, etc. the
production of clusters in must run mode is also subtracted by default.
}
\examples{
\dontrun{
# Data required by the function
showAliases("netLoad")

mydata <- readAntares(select = "netLoad")
addNetLoad(mydata)
names(mydata)

}

}
