% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_print.R
\name{print.ObliqueForest}
\alias{print.ObliqueForest}
\title{Inspect Forest Parameters}
\usage{
\method{print}{ObliqueForest}(x, ...)
}
\arguments{
\item{x}{(\emph{ObliqueForest}) an oblique random survival forest (ORSF; see \link{orsf}).}

\item{...}{Further arguments passed to or from other methods (not currently used).}
}
\value{
\code{x}, invisibly.
}
\description{
Printing an ORSF model tells you:
\itemize{
\item Linear combinations: How were these identified?
\item N observations: Number of rows in training data
\item N events: Number of events in training data
\item N trees: Number of trees in the forest
\item N predictors total: Total number of columns in the predictor matrix
\item N predictors per node: Number of variables used in linear combinations
\item Average leaves per tree: A proxy for the depth of your trees
\item Min observations in leaf: See \code{leaf_min_obs} in \link{orsf}
\item Min events in leaf: See \code{leaf_min_events} in \link{orsf}
\item OOB stat value: Out-of-bag error after fitting all trees
\item OOB stat type: How was out-of-bag error computed?
\item Variable importance: How was variable importance computed?
}
}
\examples{

object <- orsf(pbc_orsf, Surv(time, status) ~ . - id, n_tree = 5)

print(object)

}
