% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_t_test.R
\name{apa.ind.t.test}
\alias{apa.ind.t.test}
\title{Report descriptive statistics for a set of values}
\usage{
apa.ind.t.test(
  .data,
  .iv,
  .dv,
  bonferroni.multiplier = 1,
  show.mean.difference = TRUE,
  show.statistic = NULL,
  show.conf.interval = NULL,
  number.decimals = NULL,
  number.decimals.p = NULL,
  var.equal = TRUE,
  one.sided = FALSE
)
}
\arguments{
\item{.data}{A data frame or data frame extension (e.g., tibble)}

\item{.iv}{Name of the independent variable column (only 2 levels)}

\item{.dv}{Name of the dependent variable column}

\item{bonferroni.multiplier}{Multiply the p-value by this number to make a bonferroni adjustment}

\item{show.mean.difference}{Show mean difference (Bool. Default TRUE)}

\item{show.statistic}{Show t-value (Bool. Default TRUE)}

\item{show.conf.interval}{Show CI for mean difference (Bool. Default TRUE)}

\item{number.decimals}{Number of decimals used in output (excluding p-value)}

\item{number.decimals.p}{Number of decimals used in p-value output}

\item{var.equal}{(boolean) TRUE or FALSE for cell equal variances}

\item{one.sided}{(boolean) TRUE or FALSE for conducting a one-sided test}
}
\value{
R Markdown text
}
\description{
Report descriptive statistics for a set of values
}
\examples{
if  (requireNamespace("apaTables", quietly = TRUE)){
    library(dplyr)
    goggles <- apaTables::goggles

    # one-sided test
    goggles \%>\%
      filter(alcohol == "None") \%>\%
      filter(gender == "Female" | gender == "Male") \%>\%
      apa.ind.t.test(gender, attractiveness,
                     var.equal = TRUE, one.sided = TRUE)
    #two-sided test
    goggles \%>\%
      filter(alcohol == "None") \%>\%
      filter(gender == "Female" | gender == "Male") \%>\%
      apa.ind.t.test(gender, attractiveness,
                      var.equal = TRUE, one.sided = FALSE)

    #two-sided test with Bonferroni correction (three exploratory tests)
    goggles \%>\%
      filter(alcohol == "None") \%>\%
      filter(gender == "Female" | gender == "Male") \%>\%
      apa.ind.t.test(gender, attractiveness,
                     var.equal = TRUE, one.sided = FALSE,
                      bonferroni.multiplier = 3)
 }
}
