% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_adjust-autoplot.R
\name{autoplot.confint_adjust}
\alias{autoplot.confint_adjust}
\title{Plot \code{confint_adjust} object}
\usage{
autoplot.confint_adjust(object, parm, ...)
}
\arguments{
\item{object}{An \code{confint_adjust} object produced by the
\code{\link[api2lm]{confint_adjust}} function.}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}

\item{...}{Not used}
}
\value{
None.
}
\description{
Plot a \code{confint_adjust} object produced by the
\code{\link[api2lm]{confint_adjust}} function. The plotting
function internally calls the
\code{\link[ggplot2]{autoplot}} function. Note: the
\code{ggplot2} package must be loaded (i.e.,
\code{library(ggplot2)} or \code{ggplot2::autoplot}
must be specifically called for this function to work.
See Examples.
}
\examples{
fit <- lm(100/mpg ~ disp + hp + wt + am, data = mtcars)
# standard intervals
cia <- confint_adjust(fit)
# if ggplot2 package is available
if (require(ggplot2)) {
autoplot(cia)
# select subset of plots
autoplot(cia, parm = c("hp", "disp"))
}
}
\author{
Joshua French
}
