% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_summarize.R
\name{pk_summarize}
\alias{pk_summarize}
\title{Produce summary tables for a PK(PD) dataset}
\usage{
pk_summarize(
  df,
  dir = NA,
  strat.by = "NSTUDYC",
  ignore.c = TRUE,
  na = -999,
  docx = FALSE,
  pptx = FALSE,
  docx.font = "Times New Roman",
  docx.size = 9,
  docx.template = NULL,
  pptx.template = NULL,
  pptx.font = "Times New Roman",
  pptx.size = 12,
  docx.orientation = "portrait",
  ignore.request = c()
)
}
\arguments{
\item{df}{dataset produced by pk_build().}

\item{dir}{filepath for output directory.}

\item{strat.by}{vector of variables names to stratify the summary tables.}

\item{ignore.c}{ignores records flagged in the C column when TRUE.}

\item{na}{numeric value to be interpreted as NA or missing.}

\item{docx}{creates summary tables as a Word document when TRUE.}

\item{pptx}{creates summary tables as a PowerPoint document when TRUE.}

\item{docx.font}{font for the summary tables in the Word document.}

\item{docx.size}{font size for the summary tables in the Word document.}

\item{docx.template}{filepath for template .docx file. When NULL, the summary tables print to a blank document.}

\item{pptx.template}{filepath for template .pptx file. When NULL, the summary tables print to a blank slide.}

\item{pptx.font}{font for the summary tables in the PowerPoint document.}

\item{pptx.size}{font size for the summary tables in the PowerPoint document.}

\item{docx.orientation}{orientation of .docx files.}

\item{ignore.request}{vector of additional logical expressions to filter the datase prior to summary.}
}
\value{
summary tables as .csv, .docx, and .pptx files
}
\description{
Summarize BLQ distributions, categorical covariates, and continuous covariates in three tables.
Outputs are default .csv files, but can also be .docx and/or .pptx
Tables are default stratified by study, but can be stratified by any variable requested by the user.
}
\examples{
## Simple ex domain with 1 subject and 1 dose
ex <- data.frame(STUDYID = "ABC101",
                 USUBJID = "ABC101-001",
                 EXSTDTC = "2000-01-01 10:00:00",
                 EXSTDY = 1,
                 EXTPTNUM = 0,
                 EXDOSE = 100,
                 CMT = 1,
                 EXTRT = "ABC",
                 EXDOSU = "mg",
                 VISIT = "Day 1",
                 EXTPT = "Dose",
                 EXDOSFRQ = "Once",
                 EXROUTE = "Oral")

## Simple pc domain with 1 subject and 3 observations
pc <- data.frame(USUBJID = "ABC101-001",
                 PCDTC = c("2000-01-01 09:40:00",
                           "2000-01-01 10:29:00",
                           "2000-01-01 12:05:00"),
                 PCDY = 1,
                 PCTPTNUM = c(0, ##Units of hours
                              0.021,
                              0.083),
                 PCSTRESN = c(NA,
                              469,
                              870),
                 PCLLOQ = 25,
                 CMT = 2,
                 VISIT = "Day 1",
                 PCTPT = c("Pre-dose",
                           "30-min post-dose",
                           "2-hr post-dose"),
                 PCTEST = "ABC",
                 PCSTRESU = "ug/mL")

## Create with pk_build()
df <- pk_build(ex, pc)


## Generate summary statistics with pk_summarize()
pk_summarize(df)



}
