% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_list_create.R
\name{variable_list_create}
\alias{variable_list_create}
\title{Create a dataframe with standard variable names and definitions}
\usage{
variable_list_create(
  variable = NULL,
  categorization = NULL,
  description = NULL,
  comment = NA
)
}
\arguments{
\item{variable}{vector of variable names}

\item{categorization}{vector of category names}

\item{description}{vector of variable descriptions}

\item{comment}{vector of variable comments (can be left NA)}
}
\value{
dataframe of standard variable definitions
}
\description{
Variable list should be used as an input to the apmx::pk_define() function.
The user should add additional definitions to the file for custom columns with apmx::variable_list_add().
}
\examples{
vl <- variable_list_create(variable = c("WEIGHT", "HEIGHT"),
                           categorization = rep("Covariate", 2),
                           description = c("weight", "height"))

}
