% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{map}
\alias{map}
\title{Map species ranges.}
\usage{
map(
  tax,
  countries = TRUE,
  records = TRUE,
  hires = FALSE,
  zoom = FALSE,
  order = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{countries}{Maps countries according to WSC.}

\item{records}{Maps records according to GBIF and WST.}

\item{hires}{Provides high resolution maps. Beware it might take longer to render.}

\item{zoom}{If records is TRUE, the map will be zoomed to the region with records.}

\item{order}{Order taxa names alphabetically or keep as in tax.}

\item{verbose}{Display information as data are retrieved.}
}
\value{
A world map with countries and records highlighted.
}
\description{
Maps species range according to the World Spider Catalogue and records according to GBIF and the World Spider Trait database.
}
\details{
Countries based on the interpretation of the textual descriptions available at the World Spider Catalogue (2025). These might be only approximations to country level and should be taken with caution.
}
\examples{
\dontrun{
map(c("Pardosa hyperborea"))
map("Amphiledorus", zoom = TRUE, hires = TRUE)
map(c("Pardosa hyperborea", "Iberesia machadoi"), countries  = FALSE, hires = TRUE, zoom = TRUE)
}
}
\references{
Pekar et al. (2021). The World Spider Trait database: a centralized global open repository for curated data on spider traits. Database, 2021: baab064. https://doi.org/10.1093/database/baab064

World Spider Catalog (2025). World Spider Catalog. Version 26. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
