% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.r
\name{install_arcpy}
\alias{install_arcpy}
\title{Install ArcGIS Conda Environment}
\usage{
install_arcpy(
  method = "conda",
  conda = "auto",
  version = NULL,
  envname = "r-arcpy",
  extra_packages = NULL,
  restart_session = TRUE,
  python_version = NULL,
  channel = "esri",
  forge = TRUE,
  ...,
  new_env = identical(envname, "r-arcpy")
)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows.}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary.
See \strong{Finding Conda} and \code{\link[reticulate:conda_binary]{conda_binary()}} for more details.}

\item{version}{Arcpy version to install. Note that the requested
arcpy version must match your ArcGIS Pro version.}

\item{envname}{The name, or full path, of the environment in which Python
packages are to be installed. When \code{NULL} (the default), the active
environment as set by the \code{RETICULATE_PYTHON_ENV} variable will be used;
if that is unset, then the \code{r-reticulate} environment will be used.}

\item{extra_packages}{Additional Python packages to install along with
arcpy.}

\item{restart_session}{Restart R session after installing (note this will
only occur within RStudio).}

\item{python_version}{Pass a string like "3.9" to request that
conda install a specific Python version. Note that the Python
version must be compatible with the requested arcpy version. If
\code{NULL}, the latest compatible Python version will be used.}

\item{channel}{An optional character vector of conda channels to include.
When specified, the \code{forge} argument is ignored. If you need to
specify multiple channels, including the conda forge, you can use
\verb{c("conda-forge", <other channels>)}.}

\item{forge}{Boolean; include the \href{https://conda-forge.org/}{conda-forge}
repository?}

\item{...}{other arguments passed to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}}.}

\item{new_env}{If \code{TRUE}, any existing Python conda environment
specified by \code{envname} is deleted first.}
}
\value{
(Invisible) \code{TRUE} if the Conda environment was created
successfully.
}
\description{
Create a Conda environment with the "arcpy" module.
}
\details{
The Conda environment must be configured to match the
ArcGIS Pro version currently installed. If ArcGIS Pro is updated,
the Conda environment must be recreated.
}
