% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wear_flag.R
\name{get_wear_flag}
\alias{get_wear_flag}
\title{Compute wear/non-wear flag}
\usage{
get_wear_flag(acc, nonwear_0s_minimum_window = 90)
}
\arguments{
\item{acc}{A numeric vector. A minute-level activity counts data vector.}

\item{nonwear_0s_minimum_window}{A numeric scalar. A minimum number of consecutive
minutes with 0 activity count to be considered non-wear.}
}
\value{
An integer vector. It has value \code{1} for a wear
and \code{0} for non-wear flagged minute. It has the same vector length as
\code{acc} vector. If there is an \code{NA} entry in \code{acc} vector,
then the returned vector will have a corresponding entry set to  \code{NA} too.
}
\description{
Compute wear/non-wear flag (\code{1}/\code{0}) for each minute of activity
counts data.
}
\details{
Method implements wear/non-wear detection algorithm closely following that of
Choi et al. (2011).

The wear/non-wear flag is determined based on activity counts data.
A minute is classified as non-wear if it belongs to any
\code{nonwear_0s_minimum_window} minutes-long interval of consecutive values 0 in
activity counts data vector;
here, "any interval" implies that a particular minute may be located
at any location (beginning, middle, end) of interval of consecutive values 0
to be classified as a non-wear. Otherwise, a particular minute is classified
as wear.

Similarly to recommendations in Discussion in Choi et al. (2011), the method
assumes
a threshold value of 0 for nonzero counts allowed during
a nonwear time interval (I.e., no activity count equal >= 1 is allowed).
The method also assumes 90 minutes as a default for
minimum time of consecutive zero counts for a window to be flagged nonwear.
Differently from recommendations in Discussion in Choi et al. (2011), it
does not
consider any "artifactual movement" interval of nonzero counts during
a nonwear time interval.
}
\examples{
## Read exemplary data
fpath_i <- system.file("extdata", extdata_fnames[1], package = "arctools")
dat_i   <- as.data.frame(data.table::fread(fpath_i))
acc     <- dat_i$vectormagnitude
acc_ts  <- lubridate::ymd_hms(dat_i$timestamp)
## Get acc data vector in "midnight_to_midnight" format
acc <- midnight_to_midnight(acc, acc_ts)
## Get wear/non-wear flag
wear_flag <- get_wear_flag(acc)

}
\references{
Choi, L., Liu, Z., Matthews, C. E., & Buchowski, M. S. (2011). Validation of
accelerometer wear and nonwear time classification algorithm. Medicine and
Science in Sports and Exercise. https://doi.org/10.1249/MSS.0b013e3181ed61a3
}
