% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lik.R
\name{lik_pois}
\alias{lik_pois}
\title{Likelihood object for Poisson error distribution}
\usage{
lik_pois(y, scale = 1, link = c("identity", "log"))
}
\arguments{
\item{y}{Poisson observations.}

\item{scale}{Scale factor for Poisson observations: y~Pois(scale*lambda).}

\item{link}{Link function. The "identity" link directly puts unimodal prior on Poisson
intensities lambda, and "log" link puts unimodal prior on log(lambda).}
}
\description{
Creates a likelihood object for ash for use with Poisson error distribution
}
\details{
Suppose we have Poisson observations \code{y} where \eqn{y_i\sim Poisson(c_i\lambda_i)}. 
   We either put an unimodal prior g on the (scaled) intensities \eqn{\lambda_i\sim g} 
   (by specifying \code{link="identity"}) or on the log intensities 
   \eqn{log(\lambda_i)\sim g} (by specifying \code{link="log"}). Either way, 
   ASH with this Poisson likelihood function will compute the posterior mean of the 
   intensities \eqn{\lambda_i}.
}
\examples{
   beta = c(rnorm(100,50,5)) # prior mode: 50
   y = rpois(100,beta) # simulate Poisson observations
   ash(rep(0,length(y)),1,lik=lik_pois(y))

}
