% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asmbPLS.predict.R
\name{asmbPLS.predict}
\alias{asmbPLS.predict}
\title{Using an asmbPLS model for prediction of new samples}
\usage{
asmbPLS.predict(fit.results, X.matrix.new, PLS.comp)
}
\arguments{
\item{fit.results}{The output of either \code{\link[asmbPLS]{asmbPLS.fit}} or 
\code{\link[asmbPLS]{mbPLS.fit}}.}

\item{X.matrix.new}{A predictors matrix, whose predictors are the same as 
the predictors in model fitting.}

\item{PLS.comp}{Number of PLS components used for prediction.}
}
\value{
\code{asmbPLSDA.predict} returns a list containing the following components:
\item{Y_pred}{Predicted value for the new sampels.}
\item{NewX_super_score}{Predicted super score for new samples, which can be
used as predictors for other regression models.}
}
\description{
Derives predictions for new samples from a model fitted by the function
\code{\link[asmbPLS]{asmbPLS.fit}} or \code{\link[asmbPLS]{mbPLS.fit}}.
}
\examples{
## Use the example dataset
data(asmbPLS.example)
X.matrix = asmbPLS.example$X.matrix
X.matrix.new = asmbPLS.example$X.matrix.new
Y.matrix = asmbPLS.example$Y.matrix
PLS.comp = asmbPLS.example$PLS.comp
X.dim = asmbPLS.example$X.dim
quantile.comb = asmbPLS.example$quantile.comb
 
## asmbPLS fit
asmbPLS.results <- asmbPLS.fit(X.matrix = X.matrix, 
                               Y.matrix = Y.matrix, 
                               PLS.comp = PLS.comp, 
                               X.dim = X.dim, 
                               quantile.comb = quantile.comb)

## asmbPLS prediction for the new data, you could use different numbers of 
## PLS components for prediction
## Use only the first PLS component 
Y.pred.1 <- asmbPLS.predict(asmbPLS.results, X.matrix.new, 1)
## Use the first two PLS components
Y.pred.2 <- asmbPLS.predict(asmbPLS.results, X.matrix.new, 2)

}
