% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_finder.R
\name{find_function_calls_in_file}
\alias{find_function_calls_in_file}
\title{Find all function calls in file}
\usage{
find_function_calls_in_file(
  relative_path = NULL,
  foo_strings,
  filter_for_test_that = FALSE
)
}
\arguments{
\item{relative_path}{path of file to search in}

\item{foo_strings}{string vector of function names to search for}

\item{filter_for_test_that}{whether to filter for only functions used after the call to test_that. Default FALSE.}
}
\value{
a dataframe with the columns 'foo' for function name and 'location' which gives
the file in which the function is called with the line in which the function is called
appended.
}
\description{
Searches through a file for function calls using SYMBOL_FUNCTION_CALL
}
\examples{
file_path <- assertHE_example("example_project/tests/testthat/test-calculate_costs.R")
find_function_calls_in_file(
  relative_path = file_path,
  foo_strings = "calculate_costs"
)

}
