% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_factor_vector}
\alias{assert_factor_vector}
\title{Assert input is a factor}
\usage{
assert_factor_vector(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not a factor}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a factor, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert an R object is a factor.
Note that no assert_factor function exists since in R factors are always vector quantities (never scalar / in matrices)
}
\details{
Technically this function name is misleading, since \code{is.vector(factor(1)) == FALSE}
but since they act exactly like vectors to end users, I think this name is the most suitable
}
\examples{
try({
assert_factor_vector(factor(c("a", "b", "c"))) # Passes
assert_factor_vector(c("a", "b", "c")) # Throws default error
assert_factor_vector(factor(c("a", "b", "c")), "Custom error message") # Passes
assert_factor_vector(1:3, "Custom error message") # Throws custom error
})

}
\concept{assert_type}
