% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-text}
\alias{node-text}
\alias{node_text}
\alias{node_text_all}
\title{Extract the code corresponding to one or several nodes}
\usage{
node_text(x)

node_text_all(x)
}
\arguments{
\item{x}{A node, either from \code{\link[=tree_root]{tree_root()}} or from another \verb{node_*()}
function.}
}
\value{
A list with as many elements as there are in the input. Each element
is a list itself with the text corresponding to the input.
}
\description{
Those functions extract the code corresponding to the node(s):
\itemize{
\item \code{node_text()} applies on a single node, for example the output of
\code{\link[=node_get_match]{node_get_match()}}
\item \code{node_text_all()} applies on a list of nodes, for example the output of
\code{\link[=node_get_multiple_matches]{node_get_multiple_matches()}}
}
}
\examples{
src <- "x <- rnorm(100, mean = 2)
    any(duplicated(y))
    plot(mtcars)
    any(duplicated(x))"

root <- src |>
  tree_new() |>
  tree_root()

# node_text() must be applied on single nodes
root |>
  node_find(ast_rule(pattern = "plot($A)")) |>
  node_text()

# node_find_all() returns a list on nodes on which
# we can use node_text_all()
root |>
  node_find_all(ast_rule(pattern = "any(duplicated($A))")) |>
  node_text_all()
}
