% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_cooksdistance.R
\name{plotD3_cooksdistance}
\alias{plotD3_cooksdistance}
\alias{plotD3CooksDistance}
\title{Influence of observations Plot in D3 with r2d3 package.}
\usage{
plotD3_cooksdistance(
  object,
  ...,
  nlabel = 3,
  single_plot = FALSE,
  scale_plot = FALSE,
  background = FALSE
)

plotD3CooksDistance(
  object,
  ...,
  nlabel = 3,
  single_plot = FALSE,
  scale_plot = FALSE,
  background = FALSE
)
}
\arguments{
\item{object}{An object of class 'auditor_model_cooksdistance' created with \code{\link{model_cooksdistance}} function.}

\item{...}{Other objects of class 'auditor_model_cooksdistance'.}

\item{nlabel}{Number of observations with the biggest Cook's distances to be labeled.}

\item{single_plot}{Logical, indicates whenever single or facets should be plotted. By default it's FALSE.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's FALSE.}

\item{background}{Logical, available only if single_plot = FALSE. Indicates whenever background plots should be plotted. By default it's FALSE.}
}
\value{
a \code{r2d3} object
}
\description{
Plot of Cook’s distances used for estimate the influence of an single observation.
}
\details{
Cook’s distance is a tool for identifying observations that may negatively affect the model.
They may be also used for indicating regions of the design space where it would be good to obtain more observations.
Data points indicated by Cook’s distances are worth checking for validity.

Cook’s Distances are calculated by removing the i-th observation from the data and recalculating the model.
It shows how much all the values in the model change when the i-th observation is removed.

For model classes other than lm and glm the distances are computed directly from the definition.
}
\examples{

dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
cd_lm <- model_cooksdistance(lm_audit)

# plot results
plotD3_cooksdistance(cd_lm, nlabel = 5)

}
\references{
Cook, R. Dennis (1977). "Detection of Influential Observations in Linear Regression". doi:10.2307/1268249.
}
\seealso{
\code{\link{plot_cooksdistance}}
}
