% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning_eqwid.R
\name{binning_eqwid}
\alias{binning_eqwid}
\title{Equal Width Binning}
\usage{
binning_eqwid(df, feat, label, nbins = 3)
}
\arguments{
\item{df}{A data.frame with independent variables and target variable.}

\item{feat}{A name of dependent variable.}

\item{label}{A name of target variable.}

\item{nbins}{Number of bins,default:3.}
}
\value{
A data frame, including the contents of the bin, the upper bound of the bin, the lower bound of the bin, and all the contents returned by the get_IV function.
}
\description{
Equal Width Binning
}
\examples{
accepts <- read.csv( system.file( "extdata", "accepts.csv" , package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
binning_eqwid1 <- binning_eqwid( df = feature, feat = 'tot_derog', label = 'bad_ind', nbins = 3 )
}
