% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Teste_t.R
\name{teste.t}
\alias{teste.t}
\title{Teste de Student}
\usage{
teste.t(
  ...,
  titulo = "Teste t",
  x = "Grupo",
  y = "Valor",
  ajuda = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{...}{Dois vetores numericos, correspondendo aos grupos para comparacao.}

\item{titulo}{Titulo do grafico (string). Default: "Teste t".}

\item{x}{Nome do eixo x no grafico (string). Default: "Grupo".}

\item{y}{Nome do eixo y no grafico (string). Default: "Valor".}

\item{ajuda}{Logico. Se TRUE, mostra explicacao detalhada da funcao. Default: FALSE.}

\item{verbose}{Se TRUE, imprime mensagens detalhadas (default = TRUE)}
}
\value{
Lista invisivel com:
\describe{
\item{resumo}{Resumo estatistico (media e desvio padrao) por grupo}
\item{resultado}{Resultado do teste t (objeto stats::htest)}
\item{grafico}{Objeto ggplot2 com visualizacao dos grupos}
}
}
\description{
Realiza o teste t para comparacao de medias entre dois grupos,
com verificacoes de normalidade e homogeneidade e apresenta
resultado com interpretacao e grafico.
}
\examples{
x <- rnorm(30, 10)
y <- rnorm(30, 12)
teste.t(x, y)
}
