% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$summary_plot}
\alias{AUTO_VI$summary_plot}
\title{Draw a summary plot for the result}
\arguments{
\item{type}{Character. Either "auto", "density" or "rank". Option "auto"
will use the Boolean flag \code{self$check_result$lineup_check}
to determine the correct option. See also \code{\link[=AUTO_VI$summary_density_plot]{AUTO_VI$summary_density_plot()}}
and \code{\link[=AUTO_VI$summary_rank_plot]{AUTO_VI$summary_rank_plot()}}.}

\item{...}{Arguments passed to \code{\link[=AUTO_VI$summary_density_plot]{AUTO_VI$summary_density_plot()}} or
\code{\link[=AUTO_VI$summary_rank_plot]{AUTO_VI$summary_rank_plot()}}.}
}
\value{
A \code{ggplot}.
}
\description{
This function draws a summary plot for the result.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$summary_plot(type = "auto", ...)
}\if{html}{\out{</div>}}
}
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$lineup_check()
  myvi$summary_plot()
}

}
