% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_and_index.R
\name{bind_and_index}
\alias{bind_and_index}
\title{Bind and index a ResultList}
\usage{
bind_and_index(index, df_list)
}
\arguments{
\item{index}{Vector of indices}

\item{df_list}{List of data.frames to bind and index. Should NOT be a data.frame.}
}
\description{
Turn a list of data.frames (of different lengths and potentially empty)
into a single indexed data.frame. Useful to process a ResultList from `comprehendHTTP`.
}
\details{
`index` and `df_list` should be the same length. An error is raised otherwise.

bind_and_index(1:2, list(data.frame(col = "a"), data.frame(col = "b")))

bind_and_index(1:3, list(
     data.frame(col = "a"),
     data.frame(),
     data.frame(c("b", "c"))))
}
