% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_vpn_connection}
\alias{ec2_create_vpn_connection}
\title{Create Vpn Connection}
\usage{
ec2_create_vpn_connection(
  CustomerGatewayId,
  Type,
  VpnGatewayId = NULL,
  TransitGatewayId = NULL,
  DryRun = NULL,
  Options = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{CustomerGatewayId}{Character. The ID of the customer gateway.}

\item{Type}{Character. The type of VPN connection (\code{ipsec.1}).}

\item{VpnGatewayId}{Character. The ID of the virtual private gateway.[optional]}

\item{TransitGatewayId}{Character. The ID of the transit gateway.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Options}{Object. The options for the VPN connection.[optional]}

\item{TagSpecification}{List. The tags to apply to the VPN connection.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Vpn Connection
}
\section{CustomerGatewayId}{

The ID of the customer
gateway.
}

\section{Type}{

The type of VPN connection
(\code{ipsec.1}).
}

\section{VpnGatewayId}{

The ID of the virtual private gateway.
If you specify a virtual private gateway, you cannot specify a transit
gateway.
}

\section{TransitGatewayId}{

The ID of the transit gateway. If you
specify a transit gateway, you cannot specify a virtual private
gateway.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Options}{

The options for the VPN
connection.
}

\section{TagSpecification}{

The tags to apply to the VPN
connection.
}

