% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_vpn_gateway}
\alias{ec2_create_vpn_gateway}
\title{Create Vpn Gateway}
\usage{
ec2_create_vpn_gateway(
  Type,
  AvailabilityZone = NULL,
  TagSpecification = NULL,
  AmazonSideAsn = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Type}{Character. The type of VPN connection this virtual private gateway supports.}

\item{AvailabilityZone}{Character. The Availability Zone for the virtual private gateway.[optional]}

\item{TagSpecification}{List. The tags to apply to the virtual private gateway.[optional]}

\item{AmazonSideAsn}{Integer.   A private Autonomous System Number (ASN) for the Amazon side of a BGP session.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Vpn Gateway
}
\section{Type}{

The type of VPN connection this virtual
private gateway supports.
}

\section{AvailabilityZone}{

The Availability Zone for
the virtual private gateway.
}

\section{TagSpecification}{

The tags to apply to
the virtual private gateway.
}

\section{AmazonSideAsn}{


A private Autonomous System Number (ASN) for the Amazon side of a BGP
session. If you\'re using a 16-bit ASN, it must be in the 64512 to 65534
range. If you\'re using a 32-bit ASN, it must be in the 4200000000 to
4294967294 range.

Default: 64512
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

