% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_update_container_instances_state}
\alias{ecs_update_container_instances_state}
\title{Update Container Instances State}
\usage{
ecs_update_container_instances_state(
  cluster = NULL,
  containerInstances = NULL,
  status = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance...}

\item{containerInstances}{List. A list of container instance IDs or full ARN entries.}

\item{status}{Character. The container instance state with which to update the container instance.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Update Container Instances State
}
\section{cluster}{

The short name or full
Amazon Resource Name (ARN) of the cluster that hosts the container
instance to update. If you do not specify a cluster, the default cluster
is assumed.
}

\section{containerInstances}{

A list of container instance IDs or full
ARN entries.
}

\section{status}{

The container instance state with which
to update the container instance. The only valid values for this action
are \code{ACTIVE} and \code{DRAINING}. A container instance can only be updated to
\code{DRAINING} status once it has reached an \code{ACTIVE} state. If a container
instance is in \code{REGISTERING}, \code{DEREGISTERING}, or \code{REGISTRATION_FAILED}
state you can describe the container instance but will be unable to
update the container instance state.
}

