% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_bucket.R
\name{copy_object}
\alias{copy_object}
\alias{copy_bucket}
\title{Copy Objects}
\usage{
copy_object(
  from_object,
  to_object = from_object,
  from_bucket,
  to_bucket,
  headers = list(),
  ...
)

copy_bucket(from_bucket, to_bucket, ...)
}
\arguments{
\item{from_object}{A character string containing the name the object you want to copy.}

\item{to_object}{A character string containing the name the object should have in the new bucket.}

\item{from_bucket}{A character string containing the name of the bucket you want to copy from.}

\item{to_bucket}{A character string containing the name of the bucket you want to copy into.}

\item{headers}{List of request headers for the REST call.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}
}
\value{
Something...
}
\description{
Copy objects between S3 buckets
}
\details{
\code{copy_object} copies an object from one bucket to another without bringing it into local memory. For \code{copy_bucket}, all objects from one bucket are copied to another (limit 1000 objects). The same keys are used in the old bucket as in the new bucket.
}
\references{
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html}{API Documentation}
}
