% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperdrive.R
\name{grid_parameter_sampling}
\alias{grid_parameter_sampling}
\title{Define grid sampling over a hyperparameter search space}
\usage{
grid_parameter_sampling(parameter_space)
}
\arguments{
\item{parameter_space}{A named list containing each parameter and its
distribution, e.g. \code{list("parameter" = distribution)}.}
}
\value{
The \code{GridParameterSampling} object.
}
\description{
Grid sampling performs a simple grid search over all feasible values in
the defined search space. It can only be used with hyperparameters
specified using \code{choice()}.
}
\examples{
\dontrun{
param_sampling <- grid_parameter_sampling(list("num_hidden_layers" = choice(c(1, 2, 3)),
                                               "batch_size" = choice(c(16, 32))))
}
}
\seealso{
\code{choice()}
}
