% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperdrive.R
\name{loguniform}
\alias{loguniform}
\title{Specify a log uniform distribution}
\usage{
loguniform(min_value, max_value)
}
\arguments{
\item{min_value}{A double where the minimum value in the range will be
\code{exp(min_value)} (inclusive).}

\item{max_value}{A double where the maximum value in the range will be
\code{exp(min_value)} (inclusive).}
}
\value{
A list of the stochastic expression.
}
\description{
Specify a log uniform distribution.

A value is drawn according to \code{exp(uniform(min_value, max_value))} so that
the logarithm of the return value is uniformly distributed. When optimizing,
this variable is constrained to the interval
\verb{[exp(min_value), exp(max_value)]}.
}
\seealso{
\code{random_parameter_sampling()}, \code{grid_parameter_sampling()},
\code{bayesian_parameter_sampling()}
}
