% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datastore.R
\name{register_azure_postgre_sql_datastore}
\alias{register_azure_postgre_sql_datastore}
\title{Initialize a new Azure PostgreSQL Datastore.}
\usage{
register_azure_postgre_sql_datastore(
  workspace,
  datastore_name,
  server_name,
  database_name,
  user_id,
  user_password,
  port_number = NULL,
  endpoint = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{workspace}{The workspace this datastore belongs to.}

\item{datastore_name}{The datastore name.}

\item{server_name}{The PostgreSQL server name.}

\item{database_name}{The PostgreSQL database name.}

\item{user_id}{The User ID of the PostgreSQL server.}

\item{user_password}{The User Password of the PostgreSQL server.}

\item{port_number}{The Port Number of the PostgreSQL server.}

\item{endpoint}{The endpoint of the PostgreSQL server. If NULL, defaults to
postgres.database.azure.com.}

\item{overwrite}{Whether to overwrite an existing datastore. If the datastore
does not exist, it will create one. The default is FALSE.}
}
\value{
The \code{azureml.data.azure_postgre_sql_datastore.AzurePostgreSqlDatastore}
object.
}
\description{
Initialize a new Azure PostgreSQL Datastore.
}
