% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqIDHierarchy.R
\name{uniqID_hier_maker}
\alias{uniqID_hier_maker}
\title{Make hierarchical ID codes}
\usage{
uniqID_hier_maker(user = FALSE, hierarchy, end = NULL, digits = 2)
}
\arguments{
\item{user}{logical. Run function using interactive mode (prompts user for 
parameter values). Default is \code{FALSE}}

\item{hierarchy}{list. A list with each element consisting of three members
a vector of three elements (string, beginning value, end value). See examples.
Used only when \code{user=FALSE})}

\item{end}{character. A string to be appended to the end of each label.}

\item{digits}{numerical. Default is \code{2}. Number of digits to be printed, 
adding leading 0s as needed. This will apply to all levels when \code{user=FALSE}. 
When the max number of digits in the ID code is greater than number of digits 
defined in \code{digits}, then \code{digits} is automatically increased 
to avoid errors.}
}
\value{
data.frame of text labels in the first column, with additional columns 
for each level in the hierarchy list, as defined by the user.
}
\description{
Generate hierarchical ID codes for barcode labels. 
Hierarchical codes have a nested structure: e.g. Y subsamples from 
each of X individuals. Use \code{\link{uniqID_maker}} 
for sequential single-level labels. Can be run in interactive mode, 
prompting user for input. The data.frame can be saved as CSV for 
(i) the \code{\link{create_PDF}} function to generate printable 
QR-coded labels; and (ii) to downstream data collection using spreadsheet, 
relational database, etc.
}
\examples{
if(interactive()){
## for interactive mode
uniqID_hier_maker(user = TRUE)
}

## how to make hierarchy list

## create vectors for each level in the order string_prefix, beginning_value,
## end_value and combine in list

a <- c("a", 3, 6)
b <- c("b", 1, 3)
c <- list(a, b)
Labels <- uniqID_hier_maker(hierarchy = c)
Labels

## add string at end of each label
Labels <- uniqID_hier_maker(hierarchy = c, end = "end")
Labels

}
\seealso{
\code{\link{uniqID_maker}}
}
