% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backpipes.R
\name{\%<\%}
\alias{\%<\%}
\alias{\%<<\%}
\title{backpipes: \%<\%, \%<<\%}
\usage{
lhs \%<\% rhs

lhs \%<<\% rhs
}
\arguments{
\item{lhs}{argument on the lhs of the backpipe}

\item{rhs}{argument on the rhs of the backpipe}
}
\description{
Provides back-piping operators \code{\%<\%} (magrittr) or
\code{\%<<\%} (pipeR) allowing a reverses (right-to-left) order of
arguments
}
\details{
\itemize{
\item \code{\%<\%} works with magrittr. \code{\%<<\%} works with piper. They are
both based on \code{\link{backpipe}}.\cr
\item Other magrittr operators and complex expressions are not supported yet.
\item It is not possible to mix forward and and backward piping in the same
expression because of likely ambiguous results.
}
}
\examples{
  \dontrun{
    require(magrittr)
    letters \%>\% paste0( 1:26 )  # forward pipe
    paste0( 1:26 ) \%<\% letters  # backward pipe

    mean \%<\% range( na.rm = TRUE ) \%<\% c(1:5, NA)
  }
  
  \dontrun{
    require(pipeR)
    letters \%>>\% paste0( 1:26 )  # forward pipe
    paste0( 1:26 ) \%<<\% letters  # backward pipe

    mean \%<<\% range( na.rm = TRUE ) \%<<\% c(1:5, NA)
  }
  
  \dontrun{
    require(shiny)
    div( class="outer-outer") \%<\%
      div( class="outer")     \%<\% 
        div( class="inner")   \%<\% 
          h1( "content", role="heading" )
   }          

}
\references{
\url{https://github.com/smbache/magrittr/issues/26} \cr
\url{http://stackoverflow.com/questions/31305342/is-right-to-left-operator-associativity-in-r-possible} \cr
}
\seealso{
\code{\link[magrittr]{\%>\%}} \cr
\code{\link[pipeR]{\%>>\%}} \cr
}
