% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bagcv.R
\name{bagcv}
\alias{bagcv}
\title{Bagged CV bandwidth selector for Parzen-Rosenblatt estimator}
\usage{
bagcv(x, r, s, h0, h1, nb = r, ncores = parallel::detectCores())
}
\arguments{
\item{x}{Vector. Sample.}

\item{r}{Positive integer. Size of the subsamples.}

\item{s}{Positive integer. Number of subsamples.}

\item{h0}{Positive real number. Range over which to minimize, left bound.}

\item{h1}{Positive real number. Range over which to minimize, right bound.}

\item{nb}{Positive integer. Number of bins.}

\item{ncores}{Positive integer. Number of cores with which to parallelize the computations.}
}
\value{
Bagged CV bandwidth.
}
\description{
Bagged CV bandwidth selector for Parzen-Rosenblatt estimator
}
\details{
Bagged cross-validation bandwidth selector for the Parzen-Rosenblatt estimator.
}
\examples{
set.seed(1)
x <- rnorm(10^6)
bagcv(x, 5000, 100, 0.01, 1, 1000, 2)

}
