% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop_s3.R
\name{\%-=\%.bandicoot_oop}
\alias{\%-=\%.bandicoot_oop}
\title{S3 method of in-place subtraction operator of a
\code{bandicoot_oop} object}
\usage{
\method{\%-=\%}{bandicoot_oop}(x, y)
}
\arguments{
\item{x}{\code{bandicoot_oop} object.}

\item{y}{Another object.}
}
\value{
Depends on the method.
}
\description{
This function performs the in-place subtraction operator using the
\code{..iadd..()} method.
If it is not applicable, error will be raised.
}
\examples{
COMPANY <- new_class(class_name = "COMPANY")
company <- COMPANY$instantiate
register_method(COMPANY,
                ..init.. = function(name, age) {
                  self$name <- name
                  self$age <- age
                })
register_method(COMPANY,
                ..isub.. = function(y) {
                  self$age <- self$age[self$name != y]
                  self$name <- self$name[self$name != y]
                })

good_company <- company(c("patrick", "james"),
                        c(33, 34))
good_company \%-=\% "patrick"
good_company$name

}
