% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_utils.R
\name{generate_bandit_data}
\alias{generate_bandit_data}
\title{Generate classification data.}
\usage{
generate_bandit_data(xs = NULL, y = NULL, noise_std = 1, signal_strength = 1)
}
\arguments{
\item{xs}{Optional matrix. Covariates of shape \code{[A, p]}, where \code{A} is the number of observations and \code{p} is the number of features. Default is \code{NULL}. Must not contain NA values.}

\item{y}{Optional vector. Labels of length \code{A}. Default is \code{NULL}. Must not contain NA values.}

\item{noise_std}{Numeric. Standard deviation of the noise added to the potential outcomes. Default is \code{1.0}. Must be a non-negative number.}

\item{signal_strength}{Numeric. Strength of the signal in the potential outcomes. Default is \code{1.0}.}
}
\value{
A list containing the generated data (\code{xs}, \code{ys}, \code{muxs}, \code{A}, \code{p}, \code{K}) and the true class probabilities (\code{mus}).
}
\description{
Generates covariates and potential outcomes for a classification dataset.
}
\examples{
data <- generate_bandit_data(xs = as.matrix(iris[,1:4]),
                             y = as.numeric(iris[,5]),
                             noise_std = 0.1,
                             signal_strength = 1.0)

}
