% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basket.r
\name{basket_name}
\alias{basket_name}
\title{The Names of the Baskets}
\usage{
basket_name(model)
}
\arguments{
\item{model}{the model to retrieve the basket names of}
}
\description{
Retrieve the basket names in an exchangeability model.
}
\examples{
\donttest{
# 3 baskets, each with enrollement size 5
trial_sizes <- rep(5, 3)

# The response rates for the baskets.
resp_rate <- 0.15

# The trials: a column of the number of responses and a column of the
# the size of each trial.
trials <- data.frame(
  responses = rbinom(trial_sizes, trial_sizes, resp_rate),
  size = trial_sizes,
  name = paste("Basket", seq_len(3))
)

basket_name(mem_mcmc(trials$responses, trials$size, trials$basket))
}
}
