% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_design.R
\name{get_scenarios}
\alias{get_scenarios}
\title{Create a Scenario Matrix}
\usage{
get_scenarios(design, p1)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{p1}{Probabilitiy under the alternative hypothesis.}
}
\value{
A matrix with \code{k} rows and \code{k + 1} columns.
}
\description{
Creates a default scenario matrix.
}
\details{
\code{get_scenarios} creates a default scenario matrix
that can be used for \code{\link{opt_design}}. The function creates
\code{k + 1} scenarios, from a global null to a global alternative scenario.
}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
get_scenarios(design = design, p1 = 0.5)
}
