% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{mig.partraces.plot}
\alias{mig.partraces.plot}
\alias{mig.partraces.cs.plot}
\title{Plotting MCMC Parameter Traces}
\usage{
mig.partraces.plot(
  mcmc.list = NULL,
  sim.dir = NULL,
  chain.ids = NULL,
  par.names = mig.parameter.names(),
  nr.points = NULL,
  dev.ncol = 2,
  ...
)

mig.partraces.cs.plot(
  country,
  mcmc.list = NULL,
  sim.dir = NULL,
  chain.ids = NULL,
  par.names = mig.parameter.names.cs(),
  nr.points = NULL,
  dev.ncol = 3,
  ...
)
}
\arguments{
\item{mcmc.list}{List of \code{\link{bayesMig.mcmc}} objects, or an object of class
\code{\link{bayesMig.mcmc.set}} or of class \code{bayesMig.prediction}. If it is \code{NULL}, the 
traces are loaded from \code{sim.dir}.}

\item{sim.dir}{Directory with the MCMC simulation results. It is only used if \code{mcmc.list} is \code{NULL}.}

\item{chain.ids}{List of MCMC identifiers to be plotted. If it is \code{NULL}, all chains found in 
\code{mcmc.list} or \code{sim.dir} are plotted.}

\item{par.names}{Names of parameters for which traces should be plotted. By default all 
country-independent parameters are plotted if used within \code{mig.partraces.plot}, or 
country-specific parameters are plotted if used within \code{mig.partraces.cs.plot}.}

\item{nr.points}{Number of points to be plotted. If \code{NULL}, all points are plotted, 
otherwise the traces are thinned evenly.}

\item{dev.ncol}{Number of column for the graphics device. If the number of parameters is smaller
than \code{dev.ncol}, the number of columns is automatically decreased.}

\item{\dots}{Additional graphical parameters.}

\item{country}{Name or numerical code of a country. It can also be given as ISO-2 or ISO-3 characters.}
}
\value{
No return value.
}
\description{
Functions for plotting the MCMC parameter traces from the migration model.
}
\details{
The functions plot MCMC traces either for country-independent parameters 
    (\code{mig.partraces.plot} or for country-specific parameters (\code{mig.partraces.cs.plot}, 
    one graph per parameter.  One can restrict it to specific chains by setting 
    the \code{chain.ids} argument, and to specific parameters by setting the \code{par.names} 
    argument.
}
