% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_ribbonROE.R
\name{ribbonROE}
\alias{ribbonROE}
\title{Bayesian Regions of Evidence Ribbon Plot}
\usage{
ribbonROE(
  ee,
  se,
  delta = 0,
  alpha = 0.025,
  type = "threshold",
  larger = TRUE,
  meanLim = c(pmin(2 * ee, 0), pmax(0, 2 * ee)),
  sdLim = c(0, 3 * se),
  nGrid = 500,
  relative = TRUE,
  cols = NULL,
  cols_alpha = 1,
  addRef = TRUE,
  sceptPrior = 0,
  addEst = FALSE
)
}
\arguments{
\item{ee}{Effect estimate.}

\item{se}{Standard error of effect estimate.}

\item{delta}{Minimally relevant effect size. Defaults to zero. Can also be a
vector of numerical values to representing different regions.}

\item{alpha}{Posterior probability that the effect size is less extreme than
delta. Defaults to 0.025. Can also be a vector of numerical values 
representing different regions.}

\item{type}{Character indicating if regions of evidence should be constructed 
for a non-inferiority claim using the first element of delta and all 
elements of alpha ("threshold") or for a non-inferiority claim using the 
all elements of delta and the first element of alpha ("probability").
Defaults to "threshold".}

\item{larger}{Logical indicating if effect size should be larger (TRUE) or
smaller (FALSE) than delta. Defaults to TRUE.}

\item{meanLim}{Limits of prior mean axis. Defaults to interval between zero
and two times the effect estimate.}

\item{sdLim}{Limits of prior standard deviation axis. Defaults to interval
between zero and three times the standard error.}

\item{nGrid}{Number of grid points (on the standard error axis). Defaults to
500.}

\item{relative}{Logical indicating whether a second x-axis and y-axis with
relative prior mean and relative prior variance should be displayed.
Defaults to TRUE.}

\item{cols}{Character containing the HEX color code of the upper and lower
region of evidence, respectively. Defaults to NULL, which triggers
automated color picking by calling ggplot2:scale_fill_viridis_d()}

\item{cols_alpha}{Numeric value indicating the relative opacity of any
region of evidence (alpha channel). Defaults to 1 (no transparency).}

\item{addRef}{Logical indicating if a reference cross representing the minimum 
sceptical prior is added to the plot. Defaults to TRUE.}

\item{sceptPrior}{Numeric value indicating the effect location of the minimum 
sceptical prior. Defaults to 0.}

\item{addEst}{Logical indicating if a point symbol representing the mean and 
standard error of the effect estimate (ee, se) is added to the plot.
Defaults to FALSE.}
}
\value{
A bayesROE object (a list containing the ggplot object, the data for
    the plot, and the tipping point function)
}
\description{
Compute and visualize the Bayesian Regions of Evidence (Ribbon),
    that is, the set of normal priors for an effect size which - 
    when combined with the observed data - lead to a specified posterior
    probability for the effect size being more extreme than a specified
    minimally relevant effect size.
}
\examples{
## data with p < 0.025 for H0: delta < 0, but p > 0.025 for H0: delta < 0.3
d <- 0.4
d_se <- 0.1
delta <- c(0, 0.3)
ribbonROE(ee = d, se = d_se, delta = delta, meanLim = c(-1, 1))

## reproducing Figure 1 from Hoefler & Miller (2023)
ee <- 3.07
se <- 1.19
ribbonROE(ee = ee, se = se, delta = c(0,3), alpha = 0.025, 
  cols = c("#F5FF82", "#27CC1E"))$plot + 
  ggplot2::annotate(geom = "point", y = ee, x = se, shape = 4) +
  ggplot2::coord_flip(ylim = c(-5, 15))

}
\references{
Pawel, S., Matthews, R. and Held, L. (2021). Comment on
    "Bayesian additional evidence for decision making under small sample uncertainty".
    Manuscript submitted for publication. Code available at
    \url{https://osf.io/ymx92/}
}
