% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeTime.R
\name{nearestTime}
\alias{nearestTime}
\title{Merge data frames based on the nearest datetime differences.}
\usage{
nearestTime(df1, df2, timeCol1, timeCol2)
}
\arguments{
\item{df1}{Data frame containing the dates for which the differences between the other data frame's date column should be minimized for each row.}

\item{df2}{Data frame containing the dates which should be compared to, as well as other values that should be merged to df1 per minimized date time.}

\item{timeCol1}{Character vector specifying the date/time column in df1.}

\item{timeCol2}{Character vector specifying the date/time column in df2.}
}
\value{
A merged data frame that minimizes datetime differences.
}
\description{
Takes two data frames each with time/date columns in date-time or date format (i.e., able to be compared using the function difftime), finds the rows of df2 that minimize the absolute value of the datetime for each of the rows in df1, and merges the corresponding rows of df2 into df1 for downstream processing.
}

