% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedShrinkage.R
\name{weightedShrink}
\alias{weightedShrink}
\title{Weighted shrinkage estimation.}
\usage{
weightedShrink(x, n, m = NULL, meanVal = NULL)
}
\arguments{
\item{x}{Numeric vector of values to be shrunken towards the mean.}

\item{n}{Numeric vector with corresponding entries to x, specifying the number of observations used to calculate x, or some other confidence weight to associate with x.}

\item{m}{Number specifying weight of the shrinkage estimation, relative to the number of observations in the input vector n. Defaults to the minimum of n, but this is an arbitrary value and should be explored to find an optimal value for your use case.}

\item{meanVal}{Number specifying the overall mean towards which the values should be shrunken. Defaults to NULL, in which case it is calculated as the (non-weighted) arithmetic mean of the values in the inputted vector x.}
}
\value{
A numeric vector with shrunken data values.
}
\description{
Shrink values towards the mean (in the sample or the overall cohort) to an inverse degree to the confidence you assign to that observation.
}
\references{
http://math.stackexchange.com/a/41513
}

