% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression_Functions.R
\name{distreg}
\alias{distreg}
\title{Bayesian distribution regression}
\usage{
distreg(thresh, data0, MH = "IndepMH", ...)
}
\arguments{
\item{thresh}{threshold value that is used to binarise the continuous outcome variable}

\item{data0}{original data set with the first column being the continuous outcome variable}

\item{MH}{metropolis-hastings algorithm to use; default:"IndepMH", alternative "RWMH"}

\item{...}{any additional inputs to pass to the MH algorithm}
}
\value{
fitob a vector of fitted values corresponding to the distribution at threshold thresh
}
\description{
\code{distreg} draws randomly from the density of F(yo) at a threshold value yo
}
\examples{
data0=faithful[,c(2,1)]; qnt<-quantile(data0[,1],0.25)
distob<- distreg(qnt,data0,iter = 102, burn = 2); 
plot(density(distob,.1),main="Kernel density plot")

}
