% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{lapl_aprx}
\alias{lapl_aprx}
\title{Laplace approximation of posterior to normal}
\usage{
lapl_aprx(y, x, glmobj = FALSE)
}
\arguments{
\item{y}{the binary dependent variable y}

\item{x}{the matrix of independent variables.}

\item{glmobj}{logical for returning the logit glm object}
}
\value{
val A list of mode variance-covariance matrix, and scale factor for
proposal draws from the multivariate normal distribution.
}
\description{
This function generates mode and variance-covariance for a normal proposal
distribution for the bayesian logit.
}
\examples{
 y = indicat(faithful$waiting,mean(faithful$waiting)) 
 x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
 gg<- lapl_aprx(y,x)

}
