% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesmlogit.R
\name{bayesmlogit}
\alias{bayesmlogit}
\title{Multistate Life Table Method}
\usage{
bayesmlogit(
  y,
  X,
  file_path = NA,
  samp = 1000,
  burn = 500,
  verbose = 100,
  thin = 5,
  trace.plot = FALSE
)
}
\arguments{
\item{y}{A vector of state transitions, which can be created either manually or with \code{CreateTrans()}. See more details using \code{?lifedata}.}

\item{X}{A matrix of covariates. Note that \code{X} must include age as a covariate.}

\item{file_path}{The file path for outputs. If a path is specified, the result will also be saved in the given file path. You can find two result files in the specified file: \code{result.txt} and \code{resultwstep.txt}. The former contains all posterior samples generated after burn-in. The latter is sampled from the former one with a specified sampling interval.}

\item{samp}{Number of posterior samples. For efficiency purposes, if you need a large sample (e.g., \eqn{\ge}5000), we recommend parallel computing in a cluster.}

\item{burn}{'burn-in' period. Default is 500.}

\item{verbose}{Progress report. Default is 10, which means this function will report the current progress for every 10 posterior samples.}

\item{thin}{The thinning strategy to reduce autocorrelation. For example, if \code{thin = 5}, this function will select 1 from every 5 posterior samples and generate a new dataset named \code{outwstepwidth.txt}. Default is 5.}

\item{trace.plot}{If TRUE, this function will create a new directory under given \code{file_path} and output corresponding trace plots using samples after burn-in.}
}
\value{
A list that contains two arrays:
\itemize{
  \item \strong{out}: An array that contains all posterior samples generated.
  \item \strong{outwstepwidth}: An array generated by selecting one sample from every \emph{thin} samples in \strong{out}.
}
The number of columns in both arrays is determined by the number of covariates in X and the number of unique transition status in y. For example, if we have 12 covariates in X and 36 unique transitions in y, our result will contain (12+1)*(36-1)= 455 columns in total.
}
\description{
A Bayesian Multistate Life Table Method for survey data, developed by Lynch and Zang (2022), allowing for large state spaces with quasi-absorbing states (i.e., structural zeros in a transition matrix).
}
\details{
This function came from the deprecated \href{https://github.com/jwindle/BayesLogit}{bayeslogit} package, which conducts Bayesian multinomial logistic regressions using Polya-Gamma latent variables (Polson et al. 2013). It should be jointly used with the mlifetable() function, which will generate life tables based on the estimates from regressions.
}
\examples{
\dontrun{
data <- lifedata
y <- data[,1]
X <- data[,-1]

# This example will take about 30 mins.
out <- bayesmlogit(y, X ,samp=1000, burn=500,verbose=10)


}
}
\seealso{
\code{\link{mlifeTable}}, \code{\link{lifedata}}, \code{\link{CreateTrans}}
}
