% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdf.R
\name{bdf_data}
\alias{bdf_data}
\title{Fetch Banque de France (BdF) data}
\source{
\url{https://webstat.banque-france.fr/en/pages/guide-migration-api/}
}
\usage{
bdf_data(
  ...,
  key = NULL,
  start_date = NULL,
  end_date = NULL,
  api_key = bdf_key()
)
}
\arguments{
\item{...}{(\code{any})\cr
Extra arguments appended to the API request.
Combined with the default arguments with \code{\link[=modifyList]{modifyList()}}.}

\item{key}{(\code{NULL} | \code{character(1)})\cr
The series key to query. Default \code{NULL}.}

\item{start_date}{(\code{NULL} | \code{character(1)} | \code{Date(1)})\cr
Start date of the data. Default \code{NULL}.}

\item{end_date}{(\code{NULL} | \code{character(1)} | \code{Date(1)})\cr
End date of the data. Default \code{NULL}.}

\item{api_key}{(\code{character(1)})\cr
API key to use for the request. Defaults to the value returned by \code{bdf_key()}, which reads from
the \code{BANQUEDEFRANCE_KEY} environment variable.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Retrieve time series data from the BdF Webstat API.
}
\examples{
\dontrun{
bdf_data(key = "CONJ2.M.R24.T.SM.0RG24.EFTPM100.10")

# inflation rate
bdf_data(key = "ICP.M.FR.N.000000.4.ANR")

# or with a date filter
bdf_data(key = "ICP.M.FR.N.000000.4.ANR", start_date = "2025-01-01", end_date = "2025-06-30")

# advanced filter with where clause
bdf_data(key = "ICP.M.FR.N.000000.4.ANR", where = "time_period_start >= date'2025-01-01'")
}
}
\seealso{
Other data: 
\code{\link{bbk_data}()},
\code{\link{bbk_series}()},
\code{\link{bde_data}()},
\code{\link{bdf_codelist}()},
\code{\link{bdf_dataset}()},
\code{\link{boc_data}()},
\code{\link{boe_data}()},
\code{\link{ecb_data}()},
\code{\link{onb_data}()},
\code{\link{snb_data}()}
}
\concept{data}
