% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_functions.R
\name{predict.bbreg}
\alias{predict.bbreg}
\title{predict.bbreg}
\usage{
\method{predict}{bbreg}(
  object,
  newdata = NULL,
  type = c("response", "link", "precision", "variance"),
  ...
)
}
\arguments{
\item{object}{object of class "bbreg" containing results from the fitted model.}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict. If omitted, the fitted response values will be provided.}

\item{type}{the type of prediction. The default is the "response" type, which provided the estimated values for the means. The type "link" provides the estimates for the linear predictor. The type "precision" provides estimates for the precision parameters whereas the type "variance" provides estimates for the variances.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Function to obtain various predictions based on the fitted model (bessel or beta).
}
\examples{
\donttest{
fit = bbreg(agreement ~ priming + eliciting, data = WT)
predict(fit)
new_data_example = data.frame(priming = c(0,0,1), eliciting = c(0,1,1))
predict(fit, new_data = new_data_example)
predict(fit, new_data = new_data_example, type = "precision")}
}
\seealso{
\code{\link{fitted.bbreg}}, \code{\link{summary.bbreg}}, \code{\link{coef.bbreg}}, \code{\link{vcov.bbreg}}, \code{\link{plot.bbreg}}
}
