% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcrypt.R
\name{bcrypt}
\alias{bcrypt}
\alias{gensalt}
\alias{hashpw}
\alias{checkpw}
\title{Bcrypt password hashing}
\usage{
gensalt(log_rounds = 12, iv = openssl::rand_bytes(16))

hashpw(password, salt = gensalt())

checkpw(password, hash)
}
\arguments{
\item{log_rounds}{integer between 4 and 31 that defines the complexity of
the hashing, increasing the cost as \code{2^log_rounds}.}

\item{iv}{init vector to randomize the salt}

\item{password}{the message (password) to encrypt}

\item{salt}{a salt generated with \code{gensalt}.}

\item{hash}{the previously generated bcrypt hash to verify}
}
\description{
Bcrypt is used for secure password hashing. The main difference with
regular digest algorithms such as MD5 or SHA256 is that the bcrypt
algorithm is specifically designed to be CPU intensive in order to
protect against brute force attacks. The exact complexity of the
algorithm is configurable via the \code{log_rounds} parameter. The
interface is fully compatible with the Python one.
}
\details{
The \code{hashpw} function calculates a hash from a password using
a random salt. Validating the hash is done by rehashing the password
using the hash as a salt. The \code{checkpw} function is a simple
wrapper that does exactly this.

\code{gensalt} generates a random text salt for use with \code{hashpw}.
The first few characters in the salt string hold the bcrypt version number
and value for \code{log_rounds}. The remainder stores 16 bytes of base64
encoded randomness for seeding the hashing algorithm.
}
\examples{
# Secret message as a string
passwd <- "supersecret"

# Create the hash
hash <- hashpw(passwd)
hash

# To validate the hash
identical(hash, hashpw(passwd, hash))

# Or use the wrapper
checkpw(passwd, hash)

# Use varying complexity:
hash11 <- hashpw(passwd, gensalt(11))
hash12 <- hashpw(passwd, gensalt(12))
hash13 <- hashpw(passwd, gensalt(13))

# Takes longer to verify (or crack)
system.time(checkpw(passwd, hash11))
system.time(checkpw(passwd, hash12))
system.time(checkpw(passwd, hash13))
}
