% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connections.R
\name{Connections}
\alias{Connections}
\title{Class to manage the connections with YouTube}
\description{
The tasks of the functions that the \code{\link{Connections}}
class has are to establish the connections and control the number of requests
that have been made with the API of YouTube.
}
\section{Details}{

The way to indicate the keys of YouTube has to be
through fields of \emph{\link{bdpar.Options}} variable:

\strong{[youtube]}

- \code{bdpar.Options$set("youtube.app.id", <<app_id>>)}

- \code{bdpar.Options$set("youtube.app.password", <<app_password>>)}
}

\section{Note}{

Fields of unused connections will be automatically ignored by the platform.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{ExtractorYtbid}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Connections-new}{\code{Connections$new()}}
\item \href{#method-Connections-startConnectionWithYoutube}{\code{Connections$startConnectionWithYoutube()}}
\item \href{#method-Connections-addNumRequestToYoutube}{\code{Connections$addNumRequestToYoutube()}}
\item \href{#method-Connections-checkRequestToYoutube}{\code{Connections$checkRequestToYoutube()}}
\item \href{#method-Connections-getNumRequestMaxToYoutube}{\code{Connections$getNumRequestMaxToYoutube()}}
\item \href{#method-Connections-clone}{\code{Connections$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connections-new"></a>}}
\if{latex}{\out{\hypertarget{method-Connections-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{Connections}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connections-startConnectionWithYoutube"></a>}}
\if{latex}{\out{\hypertarget{method-Connections-startConnectionWithYoutube}{}}}
\subsection{Method \code{startConnectionWithYoutube()}}{
Function able to establish the connection with YouTube.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$startConnectionWithYoutube()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connections-addNumRequestToYoutube"></a>}}
\if{latex}{\out{\hypertarget{method-Connections-addNumRequestToYoutube}{}}}
\subsection{Method \code{addNumRequestToYoutube()}}{
Function that increases in one the number of request to YouTube.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$addNumRequestToYoutube()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connections-checkRequestToYoutube"></a>}}
\if{latex}{\out{\hypertarget{method-Connections-checkRequestToYoutube}{}}}
\subsection{Method \code{checkRequestToYoutube()}}{
Handles the connection with YouTube.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$checkRequestToYoutube()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connections-getNumRequestMaxToYoutube"></a>}}
\if{latex}{\out{\hypertarget{method-Connections-getNumRequestMaxToYoutube}{}}}
\subsection{Method \code{getNumRequestMaxToYoutube()}}{
Gets the number of maximum requests allowed by YouTube API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$getNumRequestMaxToYoutube()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of number maximum of request to YouTube.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connections-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Connections-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
