% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tte-sim.R
\name{sim_pw_const_haz}
\alias{sim_pw_const_haz}
\title{Simulate Event Times for Each Individual from a Piecewise Constant Hazard Model}
\usage{
sim_pw_const_haz(n, hazard_periods = NULL, hazard_values)
}
\arguments{
\item{n}{Number of individuals}

\item{hazard_periods}{Vector of break points between time periods with separate constant
hazards, e.g., c(6,8) defines [0,6), [6,8), [8, infinity). Leave as NULL if
defining only one hazard period.}

\item{hazard_values}{Vector of constant hazard values associated with the time intervals}
}
\value{
Vector of simulated times from the time-to-event distribution
}
\description{
Simulate Event Times for Each Individual from a Piecewise Constant Hazard Model
}
\details{
Simulate the event or censoring times for each participant using a
piecewise constant hazard model where each time period is defined to have
a different constant hazard. Here, \code{hazard_periods} defines the right
time points for each time period (with the exception of the last time
period which extends to infinity), and \code{hazard_values} defines the constant
hazards for each time period.
}
\examples{
tte_dat <- sim_pw_const_haz(n = 100000, hazard_periods = c(6, 8), hazard_values = c(0.1, 0.1, 0.1))
hist(tte_dat, breaks = 100, main = "Event Time Distribution", xlab = "Event Time")
}
