% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_site_model.R
\name{is_hky_site_model}
\alias{is_hky_site_model}
\title{Determine if the object is a valid HKY site model,
as created by \code{\link{create_hky_site_model}}}
\usage{
is_hky_site_model(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid HKY site model}
}
\value{
TRUE if x is a valid HKY site model, FALSE otherwise
}
\description{
Determine if the object is a valid HKY site model,
as created by \code{\link{create_hky_site_model}}
}
\examples{
check_empty_beautier_folder()

# site models
is_hky_site_model(create_hky_site_model())
is_hky_site_model(create_gtr_site_model())
is_hky_site_model(create_jc69_site_model())
is_hky_site_model(create_tn93_site_model())

# other models
is_hky_site_model(NA)
is_hky_site_model(NULL)
is_hky_site_model("nonsense")
is_hky_site_model(create_strict_clock_model())
is_hky_site_model(create_bd_tree_prior())
is_hky_site_model(create_mcmc())

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
