% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movAvLines.R
\name{movAvLines}
\alias{movAvLines}
\title{Moving average with different window widths}
\usage{
movAvLines(
  x = 1:length(y),
  y,
  widths = c(3, 5, 7, 9, 11, 13),
  weights,
  col = "blue",
  alpha = 0.3,
  add = TRUE,
  las = 1,
  ...
)
}
\arguments{
\item{x}{x values of data. DEFAULT: 1:length(y)}

\item{y}{y values that are smoothed with several window widths}

\item{widths}{widths of \code{\link{movAv}} windows. DEFAULT: 2:7*2-1}

\item{weights}{weights within each window}

\item{col}{color passed to \code{\link{addAlpha}}. DEFAULT: "blue"}

\item{alpha}{transparency passed to \code{\link{addAlpha}}. DEFAULT: 0.3}

\item{add}{Logical: Add to existing plot?Set to FALSE to first create
the scatterplot. DEFAULT: TRUE}

\item{las}{LabelAxisStyle (only relevant if add=FALSE). DEFAULT: 1}

\item{\dots}{further arguments passed to \code{\link{lines}}}
}
\description{
Add moving average lines with different window widths to a plot
}
\examples{

set.seed(42)
movAvLines(y=cumsum(rnorm(50)), add=FALSE, lwd=3)

}
\seealso{
\code{\link{movAv}}, \code{\link{addAlpha}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2015
}
\keyword{manip}
\keyword{smooth}
\keyword{ts}
