% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openPDF.R
\name{openPDF}
\alias{openPDF}
\title{open PDF file with sumatra viewer}
\usage{
openPDF(
  file,
  rspath = sub("rstudio.exe$", "", Sys.getenv("RSTUDIO_DESKTOP_EXE")),
  sumexe = NULL,
  ...
)
}
\arguments{
\item{file}{Filename to be opened, as character string.
Files not ending in ".pdf" are ignored with a warning.}

\item{rspath}{The path to Rstudio files. 
DEFAULT: \code{sub("rstudio.exe$", "", \link{Sys.getenv}("RSTUDIO_DESKTOP_EXE"))}}

\item{sumexe}{The path to SumatraPDF.exe. DEFAULT: Null: added to \code{rspath}, e.g. 
"C:/Program Files/RStudio/resources/app/bin/sumatra/SumatraPDF.exe"}

\item{\dots}{Further arguments passed to \code{\link{system}}}
}
\value{
Result of try(system, ...), invisibly
}
\description{
open PDF file with SumatraPDF viewer, which does not lock files against being edited.
It is only available on windows, but comes bundled with Rstudio.
If the executable is not found, \code{\link{openFile}} is called instead.\cr
I suggest to first change some settings with \code{\link{sumatraInitialize}()}.
}
\examples{
# only desired in an interactive session, not on CRAN checks
# openPDF( system.file("extdata/Anhang.pdf", package="berryFunctions")  )
# openPDF( system.file(c("extdata/Anhang.pdf", "extdata/RainfallStationsMap.pdf"), 
#                      package="berryFunctions")  )

}
\seealso{
\code{\link{openFile}} for the default opening programm\cr
         \code{\link{sumatraInitialize}} for nice Sumatra default settings\cr
         \code{\link{pdfpng}} to create PDFs and PNGs simultaneously.
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2020
}
\keyword{file}
